"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.extractAtomic = void 0;
const tslib_1 = require("tslib");
const fs_1 = require("fs");
const tar_1 = tslib_1.__importDefault(require("tar"));
const fs_extra_1 = require("fs-extra");
const path_1 = tslib_1.__importDefault(require("path"));
const write_file_atomic_1 = tslib_1.__importDefault(require("write-file-atomic"));
const extractAtomic = async (archivePath, destinationPath) => {
    const entryPromises = [];
    const parser = new tar_1.default.Parse();
    parser.on('entry', (entry) => {
        if (entry.type !== 'File') {
            entry.resume(); // skip non-files
            return;
        }
        const targetPath = path_1.default.join(destinationPath, entry.path);
        const p = (async () => {
            await (0, fs_extra_1.ensureDir)(path_1.default.dirname(targetPath));
            const chunks = [];
            for await (const chunk of entry) {
                chunks.push(chunk);
            }
            const content = Buffer.concat(chunks);
            await (0, write_file_atomic_1.default)(targetPath, content, {
                mode: entry.mode || 0o644,
            });
        })();
        entryPromises.push(p);
    });
    // Pipe archive into parser
    const stream = (0, fs_1.createReadStream)(archivePath);
    stream.pipe(parser);
    // Wait for parser to finish and all entry writes to complete
    await new Promise((resolve, reject) => {
        parser.on('end', resolve);
        parser.on('error', reject);
        stream.on('error', reject);
    });
    await Promise.all(entryPromises);
};
exports.extractAtomic = extractAtomic;
