"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.typescript = void 0;
const tslib_1 = require("tslib");
const debug_1 = tslib_1.__importDefault(require("debug"));
const debug = (0, debug_1.default)('cypress:server:plugins');
/**
 * Resolves the path to 'typescript' module.
 *
 * @param {projectRoot} path to the project root
 * @returns {string|null} path if typescript exists, otherwise null
 */
const typescript = (projectRoot) => {
    if (process.env['CYPRESS_INTERNAL_NO_TYPESCRIPT'] === '1' || !projectRoot) {
        return null;
    }
    try {
        debug('resolving typescript with projectRoot %o', projectRoot);
        const resolved = require.resolve('typescript', { paths: [projectRoot] });
        debug('resolved typescript %s', resolved);
        return resolved;
    }
    catch (e) {
        debug('could not resolve typescript, error: %s', e.message);
        return null;
    }
};
exports.typescript = typescript;
