import semverMajor from 'semver/functions/major';
import packageInfo from '@packages/root';
export const PLUGINS_STATE = ['uninitialized', 'initializing', 'initialized', 'error'];
export const CODE_LANGUAGES = [
    {
        type: 'js',
        name: 'JavaScript',
    },
    {
        type: 'ts',
        name: 'TypeScript',
    },
];
export const PACKAGE_MANAGERS = ['npm', 'yarn', 'pnpm'];
// Note: ONLY change this in code that will be merged into a release branch
// for a new major version of Cypress
export const GET_MAJOR_VERSION_FOR_CONTENT = () => semverMajor(packageInfo.version).toString();
export const RUN_ALL_SPECS_KEY = '__all';
export const RUN_ALL_SPECS = {
    name: 'All E2E Specs',
    absolute: RUN_ALL_SPECS_KEY,
    relative: RUN_ALL_SPECS_KEY,
    baseName: RUN_ALL_SPECS_KEY,
    fileName: RUN_ALL_SPECS_KEY,
};
/**
 * In cypress-in-cypress tests that visit the app in open mode,
 * we use this to make `isRunMode` true on the UI side so that
 * we can test some run-mode-specific UI features
 */
export const CY_IN_CY_SIMULATE_RUN_MODE = 'CY_IN_CY_SIMULATE_RUN_MODE';
// These are the URLS that we use to get the Cypress version and release time
export const CYPRESS_REMOTE_MANIFEST_URL = 'https://download.cypress.io/desktop.json';
export const NPM_CYPRESS_REGISTRY_URL = 'https://registry.npmjs.org/cypress';
/**
 * Maximum number of elements to check for visibility for the command log.
 * Beyond this limit, the visibility check is skipped to prevent browser crashes
 * when dealing with very large element sets.
 * This number is fairly arbitrary.
 */
export const MAX_VISIBILITY_CHECK_ELEMENTS = 10;
