import { visit as e } from "graphql/language/visitor.mjs";

import { Kind as n } from "graphql/language/kinds.mjs";

import { print as r } from "graphql/language/printer.mjs";

import { k as t, _ as o, s as u, C as c, m as s, a as p, b as l, c as d, d as v, e as y, g as k, f as g } from "./923bca32.mjs";

export { C as CombinedError, f as createRequest, j as getOperationName, a as makeErrorResult, m as makeResult, i as mergeResultPatch, h as stringifyVariables } from "./923bca32.mjs";

import { subscribe as x, share as E, map as b, filter as O, tap as w, merge as q, mergeMap as N, takeUntil as _, make as D, onPush as S, makeSubject as R, onEnd as P, onStart as T, publish as M, take as A, switchMap as V, fromValue as I } from "wonka";

function collectTypes(e, n) {
  if (Array.isArray(e)) {
    for (var r = 0; r < e.length; r++) {
      collectTypes(e[r], n);
    }
  } else if ("object" == typeof e && null !== e) {
    for (var t in e) {
      if ("__typename" === t && "string" == typeof e[t]) {
        n[e[t]] = 0;
      } else {
        collectTypes(e[t], n);
      }
    }
  }
  return n;
}

function collectTypesFromResponse(e) {
  return Object.keys(collectTypes(e, {}));
}

var formatNode = function(e) {
  if (e.selectionSet && !e.selectionSet.selections.some((function(e) {
    return e.kind === n.FIELD && "__typename" === e.name.value && !e.alias;
  }))) {
    return o({}, e, {
      selectionSet: o({}, e.selectionSet, {
        selections: e.selectionSet.selections.concat([ {
          kind: n.FIELD,
          name: {
            kind: n.NAME,
            value: "__typename"
          }
        } ])
      })
    });
  }
};

var F = new Map;

function formatDocument(n) {
  var r = t(n);
  var a = F.get(r.__key);
  if (!a) {
    a = e(r, {
      Field: formatNode,
      InlineFragment: formatNode
    });
    Object.defineProperty(a, "__key", {
      value: r.__key,
      enumerable: !1
    });
    F.set(r.__key, a);
  }
  return a;
}

function maskTypename(e) {
  if (!e || "object" != typeof e) {
    return e;
  }
  return Object.keys(e).reduce((function(n, r) {
    var t = e[r];
    if ("__typename" === r) {
      Object.defineProperty(n, "__typename", {
        enumerable: !1,
        value: t
      });
    } else if (Array.isArray(t)) {
      n[r] = t.map(maskTypename);
    } else if (t && "object" == typeof t && "__typename" in t) {
      n[r] = maskTypename(t);
    } else {
      n[r] = t;
    }
    return n;
  }), Array.isArray(e) ? [] : {});
}

function withPromise(e) {
  e.toPromise = function() {
    return new Promise((function(n) {
      var r = x((function(e) {
        if (!e.stale && !e.hasNext) {
          Promise.resolve().then((function() {
            r.unsubscribe();
            n(e);
          }));
        }
      }))(e);
    }));
  };
  return e;
}

function makeOperation(e, n, r) {
  if (!r) {
    r = n.context;
  }
  return {
    key: n.key,
    query: n.query,
    variables: n.variables,
    kind: e,
    context: r
  };
}

function addMetadata(e, n) {
  return makeOperation(e.kind, e, o({}, e.context, {
    meta: o({}, e.context.meta, n)
  }));
}

function noop() {}

function applyDefinitions(e, r, t) {
  for (var a = 0; a < t.length; a++) {
    if (t[a].kind === n.FRAGMENT_DEFINITION) {
      var o = t[a].name.value;
      var i = u(t[a]);
      if (!e.has(o)) {
        e.set(o, i);
        r.push(t[a]);
      } else if ("production" !== process.env.NODE_ENV && e.get(o) !== i) {
        console.warn("[WARNING: Duplicate Fragment] A fragment with name `" + o + "` already exists in this document.\nWhile fragment names may not be unique across your source, each name must be unique per document.");
      }
    } else {
      r.push(t[a]);
    }
  }
}

function gql() {
  var e = arguments;
  var r = new Map;
  var a = [];
  var o = [];
  var i = Array.isArray(arguments[0]) ? arguments[0][0] : arguments[0] || "";
  for (var u = 1; u < arguments.length; u++) {
    var c = e[u];
    if (c && c.definitions) {
      o.push.apply(o, c.definitions);
    } else {
      i += c;
    }
    i += e[0][u];
  }
  applyDefinitions(r, a, t(i).definitions);
  applyDefinitions(r, a, o);
  return t({
    kind: n.DOCUMENT,
    definitions: a
  });
}

function shouldSkip(e) {
  var n = e.kind;
  return "mutation" !== n && "query" !== n;
}

function cacheExchange(e) {
  var n = e.forward;
  var r = e.client;
  var t = e.dispatchDebug;
  var a = new Map;
  var i = Object.create(null);
  function mapTypeNames(e) {
    var n = makeOperation(e.kind, e);
    n.query = formatDocument(e.query);
    return n;
  }
  function isOperationCached(e) {
    var n = e.context.requestPolicy;
    return "query" === e.kind && "network-only" !== n && ("cache-only" === n || a.has(e.key));
  }
  return function(e) {
    var u = E(e);
    var c = b((function(e) {
      var n = a.get(e.key);
      "production" !== process.env.NODE_ENV && t(o({}, {
        operation: e
      }, n ? {
        type: "cacheHit",
        message: "The result was successfully retried from the cache"
      } : {
        type: "cacheMiss",
        message: "The result could not be retrieved from the cache"
      }));
      var i = o({}, n, {
        operation: addMetadata(e, {
          cacheOutcome: n ? "hit" : "miss"
        })
      });
      if ("cache-and-network" === e.context.requestPolicy) {
        i.stale = !0;
        reexecuteOperation(r, e);
      }
      return i;
    }))(O((function(e) {
      return !shouldSkip(e) && isOperationCached(e);
    }))(u));
    var s = w((function(e) {
      var n = e.operation;
      if (!n) {
        return;
      }
      var o = collectTypesFromResponse(e.data).concat(n.context.additionalTypenames || []);
      if ("mutation" === e.operation.kind) {
        var u = new Set;
        "production" !== process.env.NODE_ENV && t({
          type: "cacheInvalidation",
          message: "The following typenames have been invalidated: " + o,
          operation: n,
          data: {
            typenames: o,
            response: e
          },
          source: "cacheExchange"
        });
        for (var c = 0; c < o.length; c++) {
          var s = o[c];
          var f = i[s] || (i[s] = new Set);
          f.forEach((function(e) {
            u.add(e);
          }));
          f.clear();
        }
        u.forEach((function(e) {
          if (a.has(e)) {
            n = a.get(e).operation;
            a.delete(e);
            reexecuteOperation(r, n);
          }
        }));
      } else if ("query" === n.kind && e.data) {
        a.set(n.key, e);
        for (var p = 0; p < o.length; p++) {
          var l = o[p];
          (i[l] || (i[l] = new Set)).add(n.key);
        }
      }
    }))(n(O((function(e) {
      return "query" !== e.kind || "cache-only" !== e.context.requestPolicy;
    }))(b((function(e) {
      return addMetadata(e, {
        cacheOutcome: "miss"
      });
    }))(q([ b(mapTypeNames)(O((function(e) {
      return !shouldSkip(e) && !isOperationCached(e);
    }))(u)), O((function(e) {
      return shouldSkip(e);
    }))(u) ])))));
    return q([ c, s ]);
  };
}

function reexecuteOperation(e, n) {
  return e.reexecuteOperation(makeOperation(n.kind, n, o({}, n.context, {
    requestPolicy: "network-only"
  })));
}

var Q = new Set;

function ssrExchange(e) {
  var n = !(!e || !e.staleWhileRevalidate);
  var r = !(!e || !e.includeExtensions);
  var t = {};
  var a = [];
  function invalidate(e) {
    a.push(e.operation.key);
    if (1 === a.length) {
      Promise.resolve().then((function() {
        var e;
        while (e = a.shift()) {
          t[e] = null;
        }
      }));
    }
  }
  var ssr = function(a) {
    var o = a.client;
    var i = a.forward;
    return function(a) {
      var u = e && "boolean" == typeof e.isClient ? !!e.isClient : !o.suspense;
      var s = E(a);
      var f = i(O((function(e) {
        return !t[e.key] || !!t[e.key].hasNext;
      }))(s));
      var p = b((function(e) {
        var a = function deserializeResult(e, n, r) {
          return {
            operation: e,
            data: n.data ? JSON.parse(n.data) : void 0,
            extensions: r && n.extensions ? JSON.parse(n.extensions) : void 0,
            error: n.error ? new c({
              networkError: n.error.networkError ? new Error(n.error.networkError) : void 0,
              graphQLErrors: n.error.graphQLErrors
            }) : void 0,
            hasNext: n.hasNext
          };
        }(e, t[e.key], r);
        if (n && !Q.has(e.key)) {
          a.stale = !0;
          Q.add(e.key);
          reexecuteOperation(o, e);
        }
        return a;
      }))(O((function(e) {
        return !!t[e.key] && "network-only" !== e.context.requestPolicy;
      }))(s));
      if (!u) {
        f = w((function(e) {
          var n = e.operation;
          if ("mutation" !== n.kind) {
            var a = function serializeResult(e, n) {
              var r = e.hasNext;
              var t = e.data;
              var a = e.extensions;
              var o = e.error;
              var i = {};
              if (void 0 !== t) {
                i.data = JSON.stringify(t);
              }
              if (n && void 0 !== a) {
                i.extensions = JSON.stringify(a);
              }
              if (r) {
                i.hasNext = !0;
              }
              if (o) {
                i.error = {
                  graphQLErrors: o.graphQLErrors.map((function(e) {
                    if (!e.path && !e.extensions) {
                      return e.message;
                    }
                    return {
                      message: e.message,
                      path: e.path,
                      extensions: e.extensions
                    };
                  }))
                };
                if (o.networkError) {
                  i.error.networkError = "" + o.networkError;
                }
              }
              return i;
            }(e, r);
            t[n.key] = a;
          }
        }))(f);
      } else {
        p = w(invalidate)(p);
      }
      return q([ f, p ]);
    };
  };
  ssr.restoreData = function(e) {
    for (var n in e) {
      if (null !== t[n]) {
        t[n] = e[n];
      }
    }
  };
  ssr.extractData = function() {
    var e = {};
    for (var n in t) {
      if (null != t[n]) {
        e[n] = t[n];
      }
    }
    return e;
  };
  if (e && e.initialState) {
    ssr.restoreData(e.initialState);
  }
  return ssr;
}

function subscriptionExchange(e) {
  var n = e.forwardSubscription;
  var t = e.enableAllOperations;
  return function(e) {
    var a = e.client;
    var i = e.forward;
    function isSubscriptionOperation(e) {
      var n = e.kind;
      return "subscription" === n || !!t && ("query" === n || "mutation" === n);
    }
    return function(e) {
      var t = E(e);
      var u = N((function(e) {
        var i = e.key;
        var u = O((function(e) {
          return "teardown" === e.kind && e.key === i;
        }))(t);
        return _(u)(function createSubscriptionSource(e) {
          var t = n({
            key: e.key.toString(36),
            query: r(e.query),
            variables: e.variables,
            context: o({}, e.context)
          });
          return D((function(n) {
            var r = n.next;
            var o = n.complete;
            var i = !1;
            var u;
            Promise.resolve().then((function() {
              if (i) {
                return;
              }
              u = t.subscribe({
                next: function(n) {
                  return r(s(e, n));
                },
                error: function(n) {
                  return r(p(e, n));
                },
                complete: function() {
                  if (!i) {
                    i = !0;
                    if ("subscription" === e.kind) {
                      a.reexecuteOperation(makeOperation("teardown", e, e.context));
                    }
                    o();
                  }
                }
              });
            }));
            return function() {
              i = !0;
              if (u) {
                u.unsubscribe();
              }
            };
          }));
        }(e));
      }))(O(isSubscriptionOperation)(t));
      var c = i(O((function(e) {
        return !isSubscriptionOperation(e);
      }))(t));
      return q([ u, c ]);
    };
  };
}

function debugExchange(e) {
  var n = e.forward;
  if ("production" === process.env.NODE_ENV) {
    return function(e) {
      return n(e);
    };
  } else {
    return function(e) {
      return w((function(e) {
        return console.log("[Exchange debug]: Completed operation: ", e);
      }))(n(w((function(e) {
        return console.log("[Exchange debug]: Incoming operation: ", e);
      }))(e)));
    };
  }
}

function dedupExchange(e) {
  var n = e.forward;
  var r = e.dispatchDebug;
  var t = new Set;
  function filterIncomingOperation(e) {
    var n = e.key;
    var a = e.kind;
    if ("teardown" === a) {
      t.delete(n);
      return !0;
    }
    if ("query" !== a && "subscription" !== a) {
      return !0;
    }
    var o = t.has(n);
    t.add(n);
    if (o) {
      "production" !== process.env.NODE_ENV && r({
        type: "dedup",
        message: "An operation has been deduped.",
        operation: e,
        source: "dedupExchange"
      });
    }
    return !o;
  }
  function afterOperationResult(e) {
    if (!e.hasNext) {
      t.delete(e.operation.key);
    }
  }
  return function(e) {
    var r = O(filterIncomingOperation)(e);
    return w(afterOperationResult)(n(r));
  };
}

function fetchExchange(e) {
  var n = e.forward;
  var r = e.dispatchDebug;
  return function(e) {
    var t = E(e);
    var a = N((function(e) {
      var n = e.key;
      var a = O((function(e) {
        return "teardown" === e.kind && e.key === n;
      }))(t);
      var o = l(e);
      var i = d(e, o);
      var u = v(e, o);
      "production" !== process.env.NODE_ENV && r({
        type: "fetchRequest",
        message: "A fetch request is being executed.",
        operation: e,
        data: {
          url: i,
          fetchOptions: u
        },
        source: "fetchExchange"
      });
      return S((function(n) {
        var t = !n.data ? n.error : void 0;
        "production" !== process.env.NODE_ENV && r({
          type: t ? "fetchError" : "fetchSuccess",
          message: "A " + (t ? "failed" : "successful") + " fetch response has been returned.",
          operation: e,
          data: {
            url: i,
            fetchOptions: u,
            value: t || n
          },
          source: "fetchExchange"
        });
      }))(_(a)(y(e, i, u)));
    }))(O((function(e) {
      return "query" === e.kind || "mutation" === e.kind;
    }))(t));
    var o = n(O((function(e) {
      return "query" !== e.kind && "mutation" !== e.kind;
    }))(t));
    return q([ a, o ]);
  };
}

function fallbackExchange(e) {
  var n = e.dispatchDebug;
  return function(e) {
    return O((function() {
      return !1;
    }))(w((function(e) {
      if ("teardown" !== e.kind && "production" !== process.env.NODE_ENV) {
        var r = 'No exchange has handled operations of kind "' + e.kind + "\". Check whether you've added an exchange responsible for these operations.";
        "production" !== process.env.NODE_ENV && n({
          type: "fallbackCatch",
          message: r,
          operation: e,
          source: "fallbackExchange"
        });
        console.warn(r);
      }
    }))(e));
  };
}

var G = fallbackExchange({
  dispatchDebug: noop
});

function composeExchanges(e) {
  return function(n) {
    var r = n.client;
    var t = n.dispatchDebug;
    return e.reduceRight((function(e, n) {
      return n({
        client: r,
        forward: e,
        dispatchDebug: function dispatchDebug$1(e) {
          "production" !== process.env.NODE_ENV && t(o({}, {
            timestamp: Date.now(),
            source: n.name
          }, e));
        }
      });
    }), n.forward);
  };
}

function errorExchange(e) {
  var n = e.onError;
  return function(e) {
    var r = e.forward;
    return function(e) {
      return w((function(e) {
        var r = e.error;
        if (r) {
          n(r, e.operation);
        }
      }))(r(e));
    };
  };
}

var L = [ dedupExchange, cacheExchange, fetchExchange ];

var J = function Client(e) {
  if ("production" !== process.env.NODE_ENV && !e.url) {
    throw new Error("You are creating an urql-client without a url.");
  }
  var n = new Map;
  var r = new Map;
  var t = [];
  var a = R();
  var i = a.source;
  var u = a.next;
  var c = !1;
  function dispatchOperation(e) {
    c = !0;
    if (e) {
      u(e);
    }
    while (e = t.shift()) {
      u(e);
    }
    c = !1;
  }
  function makeResultSource(e) {
    var a = O((function(n) {
      return n.operation.kind === e.kind && n.operation.key === e.key && (!n.operation.context._instance || n.operation.context._instance === e.context._instance);
    }))(y);
    if (f.maskTypename) {
      a = b((function(e) {
        return o({}, e, {
          data: maskTypename(e.data)
        });
      }))(a);
    }
    if ("mutation" === e.kind) {
      return A(1)(T((function() {
        return dispatchOperation(e);
      }))(a));
    }
    return E(P((function() {
      n.delete(e.key);
      r.delete(e.key);
      for (var a = t.length - 1; a >= 0; a--) {
        if (t[a].key === e.key) {
          t.splice(a, 1);
        }
      }
      dispatchOperation(makeOperation("teardown", e, e.context));
    }))(S((function(r) {
      n.set(e.key, r);
    }))(V((function(n) {
      if ("query" !== e.kind || n.stale) {
        return I(n);
      }
      return q([ I(n), b((function() {
        return o({}, n, {
          stale: !0
        });
      }))(A(1)(O((function(n) {
        return "query" === n.kind && n.key === e.key && "cache-only" !== n.context.requestPolicy;
      }))(i))) ]);
    }))(_(O((function(n) {
      return "teardown" === n.kind && n.key === e.key;
    }))(i))(a)))));
  }
  var s = this instanceof Client ? this : Object.create(Client.prototype);
  var f = o(s, {
    url: e.url,
    fetchOptions: e.fetchOptions,
    fetch: e.fetch,
    suspense: !!e.suspense,
    requestPolicy: e.requestPolicy || "cache-first",
    preferGetMethod: !!e.preferGetMethod,
    maskTypename: !!e.maskTypename,
    operations$: i,
    reexecuteOperation: function reexecuteOperation(e) {
      if ("mutation" === e.kind || r.has(e.key)) {
        t.push(e);
        if (!c) {
          Promise.resolve().then(dispatchOperation);
        }
      }
    },
    createOperationContext: function createOperationContext(e) {
      if (!e) {
        e = {};
      }
      return o({}, {
        _instance: void 0,
        url: f.url,
        fetchOptions: f.fetchOptions,
        fetch: f.fetch,
        preferGetMethod: f.preferGetMethod
      }, e, {
        suspense: e.suspense || !1 !== e.suspense && f.suspense,
        requestPolicy: e.requestPolicy || f.requestPolicy
      });
    },
    createRequestOperation: function createRequestOperation(e, n, r) {
      var t = k(n.query);
      if ("production" !== process.env.NODE_ENV && "teardown" !== e && t !== e) {
        throw new Error('Expected operation of type "' + e + '" but found "' + t + '"');
      }
      var a = f.createOperationContext(r);
      if ("mutation" === e) {
        a._instance = [];
      }
      return makeOperation(e, n, a);
    },
    executeRequestOperation: function executeRequestOperation(e) {
      if ("mutation" === e.kind) {
        return makeResultSource(e);
      }
      return D((function(t) {
        var a = r.get(e.key);
        if (!a) {
          r.set(e.key, a = makeResultSource(e));
        }
        var i = "cache-and-network" === e.context.requestPolicy || "network-only" === e.context.requestPolicy;
        return x(t.next)(P(t.complete)(T((function() {
          var r = n.get(e.key);
          if ("subscription" === e.kind) {
            return dispatchOperation(e);
          } else if (i) {
            dispatchOperation(e);
          }
          if (null != r && r === n.get(e.key)) {
            t.next(i ? o({}, r, {
              stale: !0
            }) : r);
          } else if (!i) {
            dispatchOperation(e);
          }
        }))(a))).unsubscribe;
      }));
    },
    executeQuery: function executeQuery(e, n) {
      var r = f.createRequestOperation("query", e, n);
      return f.executeRequestOperation(r);
    },
    executeSubscription: function executeSubscription(e, n) {
      var r = f.createRequestOperation("subscription", e, n);
      return f.executeRequestOperation(r);
    },
    executeMutation: function executeMutation(e, n) {
      var r = f.createRequestOperation("mutation", e, n);
      return f.executeRequestOperation(r);
    },
    query: function query(e, n, r) {
      if (!r || "boolean" != typeof r.suspense) {
        r = o({}, r, {
          suspense: !1
        });
      }
      return withPromise(f.executeQuery(g(e, n), r));
    },
    readQuery: function readQuery(e, n, r) {
      var t = null;
      x((function(e) {
        t = e;
      }))(f.query(e, n, r)).unsubscribe();
      return t;
    },
    subscription: function subscription(e, n, r) {
      return f.executeSubscription(g(e, n), r);
    },
    mutation: function mutation(e, n, r) {
      return withPromise(f.executeMutation(g(e, n), r));
    }
  });
  var p = noop;
  if ("production" !== process.env.NODE_ENV) {
    var l = R();
    var d = l.next;
    var v = l.source;
    f.subscribeToDebugTarget = function(e) {
      return x(e)(v);
    };
    p = d;
  }
  var h = composeExchanges(void 0 !== e.exchanges ? e.exchanges : L);
  var y = E(h({
    client: f,
    dispatchDebug: p,
    forward: fallbackExchange({
      dispatchDebug: p
    })
  })(i));
  M(y);
  return f;
};

var W = J;

export { J as Client, cacheExchange, composeExchanges, W as createClient, debugExchange, dedupExchange, L as defaultExchanges, errorExchange, G as fallbackExchangeIO, fetchExchange, formatDocument, gql, makeOperation, maskTypename, ssrExchange, subscriptionExchange };
//# sourceMappingURL=urql-core.mjs.map
