var e = require("./7832a774.js");

function getRequestPromise(e) {
  return new Promise((function(t, r) {
    e.onerror = function() {
      r(e.error);
    };
    e.onsuccess = function() {
      t(e.result);
    };
  }));
}

function getTransactionPromise(e) {
  return new Promise((function(t, r) {
    e.onerror = function() {
      r(e.error);
    };
    e.oncomplete = t;
  }));
}

exports.makeDefaultStorage = function makeDefaultStorage(t) {
  if (!t) {
    t = {};
  }
  var r;
  var n = t.idbName || "graphcache-v4";
  var a = "entries";
  var i = "metadata";
  var o = Object.create(null);
  var u = Math.floor((new Date).valueOf() / 864e5);
  var c = u - (t.maxAge || 7);
  var s = indexedDB.open(n, 1);
  var l = getRequestPromise(s);
  s.onupgradeneeded = function() {
    s.result.createObjectStore(a);
    s.result.createObjectStore(i);
  };
  function serializeEntry(e) {
    return e.replace(/:/g, "%3a");
  }
  function deserializeEntry(e) {
    return e.replace(/%3a/g, ":");
  }
  function deserializeBatch(e) {
    var t = {};
    var r = "", n = "", a = "", i = 0, o = 0;
    while (o < e.length) {
      a = "";
      while (":" !== (r = e[o++]) && r) {
        a += r;
      }
      if (i) {
        t[n] = deserializeEntry(a) || void 0;
        i = 0;
      } else {
        n = deserializeEntry(a);
        i = 1;
      }
    }
    return t;
  }
  return {
    clear: function clear() {
      return l.then((function(e) {
        var t = e.transaction([ i, a ], "readwrite");
        t.objectStore(i).clear();
        t.objectStore(a).clear();
        return getTransactionPromise(t);
      }));
    },
    readMetadata: function readMetadata() {
      return l.then((function(e) {
        return getRequestPromise(e.transaction(i, "readonly").objectStore(i).get(i));
      }), (function() {
        return null;
      }));
    },
    writeMetadata: function writeMetadata(e) {
      l.then((function(t) {
        return getRequestPromise(t.transaction(i, "readwrite").objectStore(i).put(e, i));
      }), (function() {}));
    },
    writeData: function writeData(t) {
      e._extends(o, t);
      var toUndefined = function() {
        return;
      };
      return l.then((function(e) {
        return getRequestPromise(e.transaction(a, "readwrite").objectStore(a).put(function serializeBatch() {
          var e = "";
          for (var t in o) {
            var r = o[t];
            e += serializeEntry(t);
            e += ":";
            if (r) {
              e += serializeEntry(r);
            }
            e += ":";
          }
          return e;
        }(), u));
      })).then(toUndefined, toUndefined);
    },
    readData: function readData() {
      var t = [];
      return l.then((function(r) {
        var n = r.transaction(a, "readwrite");
        var i = n.objectStore(a);
        (i.openKeyCursor || i.openCursor).call(i).onsuccess = function() {
          if (this.result) {
            var r = this.result.key;
            if ("number" != typeof r || r < c) {
              i.delete(r);
            } else {
              var n = i.get(r);
              var a = t.length;
              t.push("");
              n.onsuccess = function() {
                var i = "" + n.result;
                if (r === u) {
                  e._extends(o, deserializeBatch(i));
                }
                t[a] = i;
              };
            }
            this.result.continue();
          }
        };
        return getTransactionPromise(n);
      })).then((function() {
        return deserializeBatch(t.join(""));
      }), (function() {
        return o;
      }));
    },
    onOnline: function onOnline(e) {
      if (r) {
        window.removeEventListener("online", r);
        r = void 0;
      }
      window.addEventListener("online", r = function() {
        e();
      });
    }
  };
};
//# sourceMappingURL=urql-exchange-graphcache-default-storage.js.map
