"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = loader;

var _coffeescript = _interopRequireDefault(require("coffeescript"));

var _options = _interopRequireDefault(require("./options.json"));

var _CoffeeScriptError = _interopRequireDefault(require("./CoffeeScriptError"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
	MIT License http://www.opensource.org/licenses/mit-license.php
	Author Tobias Koppers @sokra
*/
function loader(source) {
  const options = this.getOptions(_options.default);
  const callback = this.async();
  const useSourceMap = typeof options.sourceMap === "boolean" ? options.sourceMap : this.sourceMap;
  let result;

  try {
    result = _coffeescript.default.compile(source, { ...{
        sourceMap: useSourceMap,
        bare: true
      },
      ...options,
      ...{
        filename: this.resourcePath
      }
    });
  } catch (error) {
    callback(new _CoffeeScriptError.default(error));
    return;
  }

  let map;

  if (useSourceMap && result.v3SourceMap) {
    map = JSON.parse(result.v3SourceMap);
    delete map.file;
    result = result.js;
  }

  callback(null, result, map);
}