import debugFn from 'debug';
import semverMajor from 'semver/functions/major.js';
import { getVite } from './getVite.js';
import { createViteDevServerConfig } from './resolveConfig.js';
const debug = debugFn('cypress:vite-dev-server:devServer');
const ALL_FRAMEWORKS = ['react', 'vue'];
export async function devServer(config) {
    // This has to be the first thing we do as we need to source vite from their project's dependencies
    const vite = await getVite(config);
    let majorVersion = undefined;
    if (vite.version) {
        majorVersion = semverMajor(vite.version);
        debug(`Found vite version v${majorVersion}`);
    }
    else {
        debug(`vite version not found`);
    }
    debug('Creating Vite Server');
    const server = await devServer.create(config, vite);
    debug('Vite server created');
    await server.listen();
    const { port } = server.config.server;
    if (!port) {
        throw new Error('Missing vite dev server port.');
    }
    debug('Successfully launched the vite server on port', port);
    return {
        port,
        // Close is for unit testing only. We kill this child process which will handle the closing of the server
        close(cb) {
            debug('closing dev server');
            return server.close().then(() => {
                debug('closed dev server');
                cb?.();
            }).catch(cb);
        },
    };
}
devServer.create = async function createDevServer(devServerConfig, vite) {
    try {
        const config = await createViteDevServerConfig(devServerConfig, vite);
        return await vite.createServer(config);
    }
    catch (err) {
        if (err instanceof Error) {
            throw err;
        }
        throw new Error(err);
    }
};
