/* eslint-disable no-console */
import chalk from 'chalk';
import _ from 'lodash';
import path from 'path';
const pluralize = require('pluralize');
const humanTime = require('../../server/lib/util/human_time');
export { pluralize, humanTime, };
const whileMatching = (othArr) => {
    return (val, index) => {
        return val === othArr[index];
    };
};
export const parseResolvedPattern = (baseFolder, globPattern) => {
    const resolvedPath = path.resolve(baseFolder, globPattern);
    const resolvedPathParts = resolvedPath.split(path.sep);
    const folderPathPaths = baseFolder.split(path.sep);
    const commonPath = _.takeWhile(folderPathPaths, whileMatching(resolvedPathParts)).join(path.sep);
    const remainingPattern = !commonPath ? resolvedPath : resolvedPath.replace(commonPath.concat(path.sep), '');
    return [commonPath, remainingPattern];
};
export const isCypressErr = (err) => {
    return Boolean(err.isCypressErr);
};
const twoOrMoreNewLinesRe = /\n{2,}/;
export const trimMultipleNewLines = (str) => {
    return _
        .chain(str)
        .split(twoOrMoreNewLinesRe)
        .compact()
        .join('\n\n')
        .value();
};
/**
 *
 * @param err
 * @param color
 * @param causeDepth If error has a `cause` limits the maximum depth of causes to log. Set to `0` to not log any `cause`
 * @returns
 */
export const logError = function (err, color = 'red', causeDepth = 3) {
    console.log(chalk[color](err.message));
    if (err.details) {
        console.log(chalk.magenta(`\n${err.details}`));
    }
    // bail if this error came from known
    // list of Cypress errors
    if (isCypressErr(err)) {
        return;
    }
    console.log(chalk[color](err.stack ?? ''));
    if (causeDepth > 0 && err['cause']) {
        // Limit the recursions on `cause` in case there is a loop
        console.log(chalk[color]('Caused by:'));
        logError(err['cause'], color, causeDepth - 1);
    }
    return err;
};
