// src/constants.ts
var DEFAULT_TIMEOUT = 1e4;
var DEFAULT_CONFIGS = () => ({
  specs: [],
  suites: {},
  exclude: [],
  capabilities: [],
  outputDir: void 0,
  logLevel: "info",
  logLevels: {},
  groupLogsByTestSpec: false,
  excludeDriverLogs: [],
  bail: 0,
  waitforInterval: 100,
  waitforTimeout: 5e3,
  framework: "mocha",
  reporters: [],
  services: [],
  maxInstances: 100,
  maxInstancesPerCapability: 100,
  injectGlobals: true,
  filesToWatch: [],
  connectionRetryTimeout: 12e4,
  connectionRetryCount: 3,
  execArgv: [],
  runnerEnv: {},
  runner: "local",
  shard: {
    current: 1,
    total: 1
  },
  specFileRetries: 0,
  specFileRetriesDelay: 0,
  specFileRetriesDeferred: false,
  reporterSyncInterval: 100,
  reporterSyncTimeout: 5e3,
  cucumberFeaturesWithLineNumbers: [],
  /**
   * framework defaults
   */
  mochaOpts: {
    timeout: DEFAULT_TIMEOUT
  },
  jasmineOpts: {
    defaultTimeoutInterval: DEFAULT_TIMEOUT
  },
  cucumberOpts: {
    timeout: DEFAULT_TIMEOUT
  },
  /**
   * hooks
   */
  onPrepare: [],
  onWorkerStart: [],
  onWorkerEnd: [],
  before: [],
  beforeSession: [],
  beforeSuite: [],
  beforeHook: [],
  beforeTest: [],
  beforeCommand: [],
  afterCommand: [],
  afterTest: [],
  afterHook: [],
  afterSuite: [],
  afterSession: [],
  after: [],
  onComplete: [],
  onReload: [],
  beforeAssertion: [],
  afterAssertion: [],
  /**
   * cucumber specific hooks
   */
  beforeFeature: [],
  beforeScenario: [],
  beforeStep: [],
  afterStep: [],
  afterScenario: [],
  afterFeature: []
});

// src/utils.ts
function isCloudCapability(caps) {
  return Boolean(caps && (caps["bstack:options"] || caps["sauce:options"] || caps["tb:options"]));
}
var defineConfig = (options) => ({
  ...DEFAULT_CONFIGS(),
  ...options
});
function validateConfig(defaults, options, keysToKeep = []) {
  const params = {};
  for (const [name, expectedOption] of Object.entries(defaults)) {
    if (typeof options[name] === "undefined" && !expectedOption.default && expectedOption.required) {
      throw new Error(`Required option "${name.toString()}" is missing`);
    }
    if (typeof options[name] === "undefined" && expectedOption.default) {
      params[name] = expectedOption.default;
    }
    if (typeof options[name] !== "undefined") {
      const optValue = options[name];
      if (typeof optValue !== expectedOption.type) {
        throw new Error(`Expected option "${name.toString()}" to be type of ${expectedOption.type} but was ${typeof options[name]}`);
      }
      if (typeof expectedOption.validate === "function") {
        try {
          expectedOption.validate(optValue);
        } catch (e) {
          throw new Error(`Type check for option "${name.toString()}" failed: ${e.message}`);
        }
      }
      if (typeof optValue === "string" && expectedOption.match && !optValue.match(expectedOption.match)) {
        throw new Error(`Option "${name.toString()}" doesn't match expected values: ${expectedOption.match}`);
      }
      params[name] = options[name];
    }
  }
  for (const [name, option] of Object.entries(options)) {
    if (keysToKeep.includes(name)) {
      params[name] = option;
    }
  }
  return params;
}
export {
  DEFAULT_CONFIGS,
  defineConfig,
  isCloudCapability,
  validateConfig
};
