/// <reference types="node" />
export const SUPPORTED_PLATFORMS = ['linux', 'darwin', 'win32'];
export function assertValidPlatform(platform) {
    if (!SUPPORTED_PLATFORMS.includes(platform)) {
        throw new Error(`Unsupported platform ${platform}, expected ${SUPPORTED_PLATFORMS.join(', ')}`);
    }
}
